Ext.data.JsonP.sol_common_ix_functions_ChangeUser({"tagname":"class","name":"sol.common.ix.functions.ChangeUser","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.ChangeUser.js","href":"sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloix":true,"requires":["sol.common.MapTable","sol.common.SordUtils","sol.common.WfMap","sol.common.WfUtils","sol.common.ix.DynAdHocFlowUtils","sol.common.ix.FunctionBase"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"changeCurrentNode","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-changeCurrentNode","meta":{}},{"name":"currentNodeId","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-currentNodeId","meta":{"required":true}},{"name":"defaultFromIndex","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-defaultFromIndex","meta":{}},{"name":"defaultFromMap","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-defaultFromMap","meta":{}},{"name":"defaultFromWfMap","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-defaultFromWfMap","meta":{}},{"name":"defaultFromWfMapTable","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-defaultFromWfMapTable","meta":{}},{"name":"defaultUser","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-defaultUser","meta":{"required":true}},{"name":"fromIndex","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-fromIndex","meta":{}},{"name":"fromMap","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-fromMap","meta":{}},{"name":"fromWfMap","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-fromWfMap","meta":{}},{"name":"fromWfMapTable","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-fromWfMapTable","meta":{}},{"name":"logFallbackMode","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-logFallbackMode","meta":{}},{"name":"nodeEscalations","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-nodeEscalations","meta":{}},{"name":"nodeId","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-nodeId","meta":{}},{"name":"nodeName","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-nodeName","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.FunctionBase","id":"cfg-objId","meta":{}},{"name":"previousUserWfMapFieldName","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-previousUserWfMapFieldName","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"skipNonUserNodes","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-skipNonUserNodes","meta":{}},{"name":"supervisor","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-supervisor","meta":{}},{"name":"userDelayDays","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-userDelayDays","meta":{}},{"name":"userRights","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-userRights","meta":{}},{"name":"wFDiagram","tagname":"cfg","owner":"sol.common.ix.functions.ChangeUser","id":"cfg-wFDiagram","meta":{"required":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"findNextUserNodes","tagname":"method","owner":"sol.common.ix.functions.ChangeUser","id":"method-findNextUserNodes","meta":{"private":true}},{"name":"getUserFromField","tagname":"method","owner":"sol.common.ix.functions.ChangeUser","id":"method-getUserFromField","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.functions.ChangeUser","id":"method-initialize","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.ChangeUser","id":"method-process","meta":{}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.ChangeUser","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.ChangeUser","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.ChangeUser","short_doc":"Changes the user of a workflow node. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.ChangeUser</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.MapTable' rel='sol.common.MapTable' class='docClass'>sol.common.MapTable</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.WfMap' rel='sol.common.WfMap' class='docClass'>sol.common.WfMap</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.DynAdHocFlowUtils' rel='sol.common.ix.DynAdHocFlowUtils' class='docClass'>sol.common.ix.DynAdHocFlowUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser' target='_blank'>sol.common.ix.functions.ChangeUser.js</a></div></pre><div class='doc-contents'><p>Changes the user of a workflow node.</p>\n\n<p>The user will be read from an index field (<code>fromIndex</code>), a map field (<code>fromMap</code>) or from a workflow map field (<code>fromWfMap</code>).\nIf more then one was defined, the priority is <code>fromIndex</code> -> <code>fromMap</code> -> <code>fromWfMap</code>.\nThe same rule applies for <code>defaultFromIndex</code> -> <code>defaultFromMap</code>. The defaultFrom-properties can be used to read a fallback user\nfrom a field, if the user defined in a fromIndex-field was not valid.\nIf no user was found, the default user will be used.</p>\n\n<p>The WF-Map Field <code>CHANGEUSER_CHANGEDUSERBY</code> is filled depending on which source was used for setting the user if logFallbackMode is true.\n\"FROMFIELD\"     -> User defined in a configured <code>from*-property</code> was used\n\"DEFAULTFIELD\"  -> Fallback-user defined in a configured <code>defaultFrom*-property</code> was used\n\"SUPERVISOR\"    -> <code>supervisor-property</code> was used\n\"DEFAULT\"       -> <code>default-property</code> was used\n\"ADMINISTRATOR\" -> Administrator was used because none of the other users was valid.\nThis can be especially useful, if you wish to inform a workflow-form user that he/she only received the form because of a fallback</p>\n\n<p>The node can be specified by the nodes ID or name.\nIf booth are defined, the ID will be used.\nIf <code>changeCurrentNode</code> is true, the node with the currentNodeId will be altered.\nIf neither <code>nodeId</code>, nor <code>nodeName</code> is specified, the script tries to alter all direct successor person nodes.</p>\n\n<h1>As workflow node</h1>\n\n<ul>\n<li><code>ObjId</code> is set based on the element that the workflow is attached to.</li>\n<li><code>CurrentNodeId</code> is set based on the workflow node which executes the script.</li>\n</ul>\n\n\n<p>Following configuration should be applied to the comments field.</p>\n\n<pre><code>{\n  \"defaultUser\": \"ELO Service\",\n  \"nodeId\": 7,\n  \"fromIndex\": \"OWNER\",\n  \"userRights\": { \"r\": true }\n}\n</code></pre>\n\n<h1>Prerequisites</h1>\n\n<p>This function modul can only be used in workflow scripts.</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-currentNodeId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-currentNodeId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-currentNodeId' class='name expandable'>currentNodeId</a> : Number<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>The ID of the current node. ...</div><div class='long'><p>The ID of the current node.\nIt is used to find the successing person nodes if no ID or name is defined, or to change the user of the node itself, if changeCurrentNode is true</p>\n</div></div></div><div id='cfg-defaultUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-defaultUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-defaultUser' class='name expandable'>defaultUser</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>The user that should be set if none is specified/found</p>\n</div><div class='long'><p>The user that should be set if none is specified/found</p>\n</div></div></div><div id='cfg-wFDiagram' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-wFDiagram' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-wFDiagram' class='name expandable'>wFDiagram</a> : de.elo.ix.client.WFDiagram<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>The WFDiagram to which the changes should me applied to</p>\n</div><div class='long'><p>The WFDiagram to which the changes should me applied to</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-changeCurrentNode' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-changeCurrentNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-changeCurrentNode' class='name expandable'>changeCurrentNode</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>if true, the user of the current node will be changed, regardless if an ID or name is defined;\nof course this will on...</div><div class='long'><p>if true, the user of the current node will be changed, regardless if an ID or name is defined;\nof course this will only work on nodes with type = WFNodeC.TYPE_PERSONNODE</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-defaultFromIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-defaultFromIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-defaultFromIndex' class='name expandable'>defaultFromIndex</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Read default user from a group field</p>\n</div><div class='long'><p>Read default user from a group field</p>\n</div></div></div><div id='cfg-defaultFromMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-defaultFromMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-defaultFromMap' class='name expandable'>defaultFromMap</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Read default user from a map field</p>\n</div><div class='long'><p>Read default user from a map field</p>\n</div></div></div><div id='cfg-defaultFromWfMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-defaultFromWfMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-defaultFromWfMap' class='name expandable'>defaultFromWfMap</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Read default user from a workflow map field</p>\n</div><div class='long'><p>Read default user from a workflow map field</p>\n</div></div></div><div id='cfg-defaultFromWfMapTable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-defaultFromWfMapTable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-defaultFromWfMapTable' class='name expandable'>defaultFromWfMapTable</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Read default user from workflow map table</p>\n</div><div class='long'><p>Read default user from workflow map table</p>\n</div></div></div><div id='cfg-fromIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-fromIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-fromIndex' class='name expandable'>fromIndex</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Read user from a group field</p>\n</div><div class='long'><p>Read user from a group field</p>\n</div></div></div><div id='cfg-fromMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-fromMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-fromMap' class='name expandable'>fromMap</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Read user from a map field</p>\n</div><div class='long'><p>Read user from a map field</p>\n</div></div></div><div id='cfg-fromWfMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-fromWfMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-fromWfMap' class='name expandable'>fromWfMap</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Read user from a workflow map field</p>\n</div><div class='long'><p>Read user from a workflow map field</p>\n</div></div></div><div id='cfg-fromWfMapTable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-fromWfMapTable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-fromWfMapTable' class='name expandable'>fromWfMapTable</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Read user from workflow map table</p>\n</div><div class='long'><p>Read user from workflow map table</p>\n</div></div></div><div id='cfg-logFallbackMode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-logFallbackMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-logFallbackMode' class='name expandable'>logFallbackMode</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs the user change fallback mode to the WF-Map Field CHANGEUSER_CHANGEDUSERBY ...</div><div class='long'><p>Logs the user change fallback mode to the WF-Map Field <code>CHANGEUSER_CHANGEDUSERBY</code></p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-nodeEscalations' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-nodeEscalations' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-nodeEscalations' class='name expandable'>nodeEscalations</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Node escalations ...</div><div class='long'><p>Node escalations</p>\n<ul><li><span class='pre'>user</span> : Object<div class='sub-desc'><p>Node escalation user</p>\n<ul><li><span class='pre'>value</span> : String<div class='sub-desc'><p>Node escalation user name</p>\n</div></li><li><span class='pre'>supervisor</span> : Boolean (optional)<div class='sub-desc'><p>Escalate to the users supervisor</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li><li><span class='pre'>timeLimitMinutes</span> : Number<div class='sub-desc'><p>Node escalation minutes</p>\n\n<p>If no user has been set, the new node user is used.</p>\n\n<p>Example:\n    {\n      \"fromWfMapTable\": \"USER\",\n      \"defaultUser\": \"Administrator\",\n      \"nodeEscalations\": [{\n        \"user\": {\n          \"supervisor\": true\n        },\n        \"timeLimitMinutes\": 1440\n      }]\n    }</p>\n</div></li></ul></div></div></div><div id='cfg-nodeId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-nodeId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-nodeId' class='name expandable'>nodeId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Find node to change by node.id</p>\n</div><div class='long'><p>Find node to change by node.id</p>\n</div></div></div><div id='cfg-nodeName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-nodeName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-nodeName' class='name expandable'>nodeName</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Find node to change by node.name</p>\n</div><div class='long'><p>Find node to change by node.name</p>\n</div></div></div><div id='cfg-objId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-previousUserWfMapFieldName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-previousUserWfMapFieldName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-previousUserWfMapFieldName' class='name expandable'>previousUserWfMapFieldName</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Name of the previous user workflow map field ...</div><div class='long'><p>Name of the previous user workflow map field</p>\n<p>Defaults to: <code>PREVIOUS_USER</code></p></div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;wFDiagram&quot;, &quot;currentNodeId&quot;, &quot;defaultUser&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-skipNonUserNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-skipNonUserNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-skipNonUserNodes' class='name expandable'>skipNonUserNodes</a> : Integer<span class=\"signature\"></span></div><div class='description'><div class='short'>if set to a value > 0, x nodes will be skipped in search for (a) user node(s)\nthis is useful, if you can't use Change...</div><div class='long'><p>if set to a value > 0, x nodes will be skipped in search for (a) user node(s)\nthis is useful, if you can't use ChangeUser directly before a user-node but have to put some\nother command e.g. ChangeRights inbetween.\nAttention: This does not traverse multiple routes.</p>\n</div></div></div><div id='cfg-supervisor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-supervisor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-supervisor' class='name expandable'>supervisor</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the supervisor of the given user as node user ...</div><div class='long'><p>Sets the supervisor of the given user as node user</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-userDelayDays' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-userDelayDays' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-userDelayDays' class='name expandable'>userDelayDays</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>The person node might be displayed to the user delayed by this number of days. ...</div><div class='long'><p>The person node might be displayed to the user delayed by this number of days.</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='cfg-userRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-cfg-userRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-cfg-userRights' class='name expandable'>userRights</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Rights that will be added for the node user to the workflow object and it's children\n\nExample for read access:\n\n{ r: ...</div><div class='long'><p>Rights that will be added for the node user to the workflow object and it's children</p>\n\n<p>Example for read access:</p>\n\n<pre><code>{ r: true }\n</code></pre>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-findNextUserNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-method-findNextUserNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-method-findNextUserNodes' class='name expandable'>findNextUserNodes</a>( <span class='pre'>wf, cur, max</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wf</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>cur</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>max</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getUserFromField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-method-getUserFromField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-method-getUserFromField' class='name expandable'>getUserFromField</a>( <span class='pre'>fromIndex, fromMap, fromWfMap, fromWfMapTable</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromIndex</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>fromMap</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>fromWfMap</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>fromWfMapTable</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Change the node user. ...</div><div class='long'><p>Change the node user.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-onEnterNode' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeUser'>sol.common.ix.functions.ChangeUser</span><br/><a href='source/sol.common.ix.functions.ChangeUser.html#sol-common-ix-functions-ChangeUser-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeUser-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});